<?php
include 'admin/koneksi.php';

$query = mysqli_query($conn, "
    SELECT * FROM artikel 
    WHERE status='published' 
    ORDER BY tanggal DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Artikel Hukum | WTC & PARTNERS</title>
  <link rel="icon" href="./images/image.png">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.3/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <style>
    body{
      font-family: 'Poppins', sans-serif;
      background:#f4f6f9;
    }
    .hero{
      background: linear-gradient(rgba(0,46,95,.8), rgba(0,46,95,.8)), url('./images/img1.png');
      background-size: cover;
      background-position: center;
      padding:7rem 1rem;
      text-align:center;
      color:#fff;
    }
    .hero h1{
      font-size:3.8rem;
      letter-spacing:1px;
    }
    .hero p{
      font-size:1.6rem;
      margin-top:1rem;
    }
    .article-list{
      margin-top:-4rem;
    }
    .article-item{
      background:#fff;
      border-radius:12px;
      padding:2rem;
      display:flex;
      gap:2rem;
      margin-bottom:2.5rem;
      box-shadow:0 4px 15px rgba(0,0,0,.08);
      transition:.3s;
    }
    .article-item:hover{
      transform:translateY(-5px);
    }
    .article-thumb{
      width:35%;
      border-radius:10px;
      object-fit:cover;
    }
    .article-content h3{
      font-size:2.2rem;
      color:#002e5f;
    }
    .article-meta{
      font-size:1.3rem;
      color:#888;
      margin:.5rem 0 1rem;
    }
    .article-content p{
      font-size:1.4rem;
      color:#333;
      line-height:1.7;
    }
    .btn-read{
      display:inline-block;
      margin-top:1rem;
      padding:.6rem 1.5rem;
      border:1px solid #002e5f;
      border-radius:30px;
      font-size:1.3rem;
      color:#002e5f;
      text-decoration:none;
      transition:.3s;
    }
    .btn-read:hover{
      background:#002e5f;
      color:#fff;
    }
    .sidebar{
      background:#fff;
      border-radius:12px;
      padding:2rem;
      box-shadow:0 4px 15px rgba(0,0,0,.08);
    }
    .sidebar h4{
      font-size:1.8rem;
      margin-bottom:1.5rem;
      color:#002e5f;
    }
    .sidebar ul{
      list-style:none;
      padding:0;
    }
    .sidebar ul li{
      margin-bottom:1rem;
    }
    .sidebar ul li a{
      color:#333;
      font-size:1.4rem;
      text-decoration:none;
    }
    .sidebar ul li a:hover{
      color:#00bfff;
    }
    footer{
      background:#002e5f;
      color:#fff;
      text-align:center;
      padding:2rem 1rem;
      margin-top:4rem;
      font-size:1.3rem;
    }
    @media(max-width:768px){
      .article-item{flex-direction:column;}
      .article-thumb{width:100%;}
      .article-list{margin-top:2rem;}
    }
  </style>
</head>
<body>

<section class="hero">
  <h1>Artikel & Insight Hukum</h1>
  <p>Referensi hukum terpercaya dari WTC & PARTNERS</p>
</section>

<section class="container article-list">
  <div class="row">

    <?php while($row = mysqli_fetch_assoc($query)): ?>
<div class="article-item">
    <img src="admin/uploads/<?= htmlspecialchars($row['gambar']) ?>" class="article-thumb">

    <div class="article-content">
        <h3><?= htmlspecialchars($row['judul']) ?></h3>

        <div class="article-meta">
            <i class="fa fa-calendar"></i>
            <?= date('d M Y', strtotime($row['tanggal'])) ?>
            | <i class="fa fa-user"></i> Admin
        </div>

        <p>
            <?= substr(strip_tags($row['konten']), 0, 150) ?>...
        </p>

        <a href="artikel-detail.php?id=<?= $row['id'] ?>" class="btn-read">
            Baca Artikel
        </a>
    </div>
</div>
<?php endwhile; ?>


    <div class="col-lg-4">
      <aside class="sidebar">
        <h4>Kategori Artikel</h4>
        <ul>
          <li><a href="#">Hukum Perdata</a></li>
          <li><a href="#">Hukum Pidana</a></li>
          <li><a href="#">Hukum Keluarga</a></li>
          <li><a href="#">Tips Hukum</a></li>
        </ul>
      </aside>
    </div>

  </div>
</section>

<footer>
  &copy; 2025 WTC & PARTNERS. All R