<?php
include 'admin/koneksi.php';

$id = $_GET['id'];
$data = mysqli_query($conn, "
    SELECT * FROM artikel 
    WHERE id='$id' AND status='published'
");
$artikel = mysqli_fetch_assoc($data);


$url = "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$judul = urlencode($artikel['judul']);
$link  = urlencode($url);

?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Langkah Awal Menghadapi Permasalahan Hukum | WTC & PARTNERS</title>
  <link rel="icon" href="./images/image.png">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.3/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <style>
    body{
      font-family:'Poppins',sans-serif;
      background:#f4f6f9;
    }
    .article-hero{
      background:linear-gradient(rgba(0,46,95,.85),rgba(0,46,95,.85)),url('./images/artikel1.jpg');
      background-size:cover;
      background-position:center;
      padding:6rem 1rem;
      color:#fff;
    }
    .article-hero h1{
      font-size:3.2rem;
      margin-bottom:1rem;
    }
    .article-meta{
      font-size:1.4rem;
      color:#ddd;
    }
    .article-content{
      background:#fff;
      border-radius:12px;
      padding:3rem;
      margin-top:-4rem;
      box-shadow:0 4px 20px rgba(0,0,0,.1);
    }
    .article-content p{
      font-size:1.5rem;
      line-height:1.8;
      color:#333;
      margin-bottom:1.8rem;
      text-align:justify;
    }
    .article-content h3{
      font-size:2.2rem;
      color:#002e5f;
      margin:2.5rem 0 1.2rem;
    }
    .article-content blockquote{
      border-left:4px solid #00bfff;
      padding-left:1.5rem;
      color:#555;
      font-style:italic;
      margin:2rem 0;
    }
    .sidebar{
      background:#fff;
      border-radius:12px;
      padding:2rem;
      box-shadow:0 4px 15px rgba(0,0,0,.08);
    }
    .sidebar h4{
      font-size:1.8rem;
      margin-bottom:1.5rem;
      color:#002e5f;
    }
    .sidebar ul{
      list-style:none;
      padding:0;
    }
    .sidebar ul li{
      margin-bottom:1rem;
    }
    .sidebar ul li a{
      font-size:1.4rem;
      color:#333;
      text-decoration:none;
    }
    .sidebar ul li a:hover{
      color:#00bfff;
    }
    .back-link{
      display:inline-block;
      margin-top:2rem;
      font-size:1.4rem;
      color:#002e5f;
      text-decoration:none;
    }
    .back-link:hover{
      text-decoration:underline;
    }
    footer{
      background:#002e5f;
      color:#fff;
      text-align:center;
      padding:2rem 1rem;
      margin-top:4rem;
      font-size:1.3rem;
    }
    @media(max-width:768px){
      .article-content{padding:2rem;}
      .article-hero h1{font-size:2.4rem;}
    }
  </style>
</head>
<body>

<script>
function copyLink(){
  navigator.clipboard.writeText("<?= $url ?>");
  alert("Link artikel berhasil disalin!");
}
</script>

<body>

<!-- HERO -->
<section class="article-hero">
  <div class="container text-center">
    <h1><?= htmlspecialchars($artikel['judul']) ?></h1>
    <div class="article-meta mt-3">
      <i class="fa fa-calendar"></i>
      <?= date('d F Y', strtotime($artikel['tanggal'])) ?>
      &nbsp; • &nbsp;
      <i class="fa fa-user"></i> Admin WTC & PARTNERS
    </div>
  </div>
</section>

<!-- CONTENT -->
<section class="container">
  <div class="row justify-content-center">

    <!-- ARTIKEL -->
    <div class="col-lg-8">
      <article class="article-content">

  <?php if (!empty($artikel['gambar'])) : ?>
    <img 
      src="admin/uploads/<?= htmlspecialchars($artikel['gambar']) ?>" 
      class="img-fluid rounded mb-4"
      alt="<?= htmlspecialchars($artikel['judul']) ?>"
    >
  <?php endif; ?>

  <div class="article-body">
    <?= nl2br($artikel['konten']) ?>
  </div>

  <!-- SHARE SECTION (DI BAWAH ARTIKEL) -->
  <div class="share-box mt-5">
    <span>Bagikan:</span>

    <!-- WhatsApp -->
    <a 
      href="https://wa.me/?text=<?= $judul ?>%20<?= $link ?>" 
      target="_blank"
      class="share-btn wa"
    >
      <i class="fa fa-whatsapp"></i>
    </a>

    <!-- Facebook -->
    <a 
      href="https://www.facebook.com/sharer/sharer.php?u=<?= $link ?>" 
      target="_blank"
      class="share-btn fb"
    >
      <i class="fa fa-facebook"></i>
    </a>

    <!-- Twitter / X -->
    <a 
      href="https://twitter.com/intent/tweet?text=<?= $judul ?>&url=<?= $link ?>" 
      target="_blank"
      class="share-btn tw"
    >
      <i class="fa fa-twitter"></i>
    </a>

    <!-- Copy Link -->
    <button 
      onclick="copyLink()"
      class="share-btn copy"
      type="button"
    >
      <i class="fa fa-link"></i>
    </button>
  </div>

  <a href="artikel.php" class="back-link">
    ← Kembali ke Daftar Artikel
  </a>

</article>

    </div>

    <!-- SIDEBAR -->
    <div class="col-lg-4 mt-5 mt-lg-0">
      <aside class="sidebar">
        <h4>Artikel Terkait</h4>
        <ul>
          <li><a href="#">Perbedaan Perkara Perdata dan Pidana</a></li>
          <li><a href="#">Hak Anak dalam Perceraian</a></li>
          <li><a href="#">Tips Menghadapi Pemeriksaan Hukum</a></li>
        </ul>
      </aside>
    </div>

  </div>
</section>


<footer>
  Copyright &copy; 2025 Olga Zamelda. All Rights Reserved.
</footer>

</body>
</html>
