<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

include 'koneksi.php';

$query = mysqli_query($conn, "SELECT * FROM artikel ORDER BY id DESC");

?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Artikel - WTC Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="css/artikel.css">
</head>
<body>

<div class="sidebar">
    <div class="sidebar-brand">
        <h2>WTC <span>ADMIN</span></h2>
    </div>
    <ul>
        <li><a href="dashboard.php"><i class="fas fa-chart-pie"></i> Dashboard</a></li>
        <li><a class="active" href="artikel.php"><i class="fas fa-file-alt"></i> Artikel</a></li>
        <li><a href="kontak.php"><i class="fas fa-paper-plane"></i> Pesan</a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
    </ul>
</div>

<div class="content">
    <header class="topbar">
        <div class="header-left">
            <h1>Manajemen Artikel</h1>
            <p>Atur dan publikasikan konten Anda</p>
        </div>
        <div class="user-profile">
            <div class="user-info">
                <span><?= htmlspecialchars($_SESSION['username']); ?></span>
                <small>Administrator</small>
            </div>
            <img src="https://ui-avatars.com/api/?name=<?= $_SESSION['username']; ?>&background=3b82f6&color=fff" alt="Avatar">
        </div>
    </header>

    <div class="toolbar">
        <div class="search-wrapper">
            <i class="fas fa-search"></i>
            <input type="text" placeholder="Cari judul artikel...">
        </div>
        <div class="filter-group">
            <select class="filter-select">
                <option value="">Semua Kategori</option>
                <option value="edukasi">Edukasi</option>
                <option value="berita">Berita</option>
            </select>

           <a href="tambah_artikel.php" class="btn btn-add">
    <i class="fas fa-plus"></i> Tambah Artikel
</a>


<a href="hapus_artikel.php?id=<?= $row['id'] ?>" 
   class="btn-delete"
   onclick="return confirm('Hapus artikel ini?')">
   <i class="fas fa-trash-alt"></i>
</a>

        </div>
    </div>

    <div class="table-container">
        <table class="modern-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Artikel</th>
                    <th>Kategori</th>
                    <th>Tanggal Rilis</th>
                    <th>Status</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
<?php $no=1; while($row = mysqli_fetch_assoc($query)): ?>
<tr>
    <td><?= $no++ ?></td>
    <td>
        <div class="article-cell">
            <img src="uploads/<?= htmlspecialchars($row['gambar']) ?>" alt="thumb">
            <div class="article-info">
                <span class="title"><?= htmlspecialchars($row['judul']) ?></span>
                <span class="author">Oleh Admin</span>
            </div>
        </div>
    </td>
    <td>
        <span class="category-tag"><?= htmlspecialchars($row['kategori']) ?></span>
    </td>
    <td><?= date('d M Y', strtotime($row['tanggal'])) ?></td>
    <td>
        <span class="status-badge <?= $row['status']=='published'?'published':'draft' ?>">
            <?= ucfirst($row['status']) ?>
        </span>
    </td>
    <td class="text-center">
        <div class="action-btns">
            <a href="tambah_artikel.php?id=<?= $row['id'] ?>" class="btn-edit">
                <i class="fas fa-edit"></i>
            </a>
            <a href="hapus_artikel.php?id=<?= $row['id'] ?>" 
               class="btn-delete"
               onclick="return confirm('Hapus artikel ini?')">
                <i class="fas fa-trash-alt"></i>
            </a>
        </div>
    </td>
</tr>
<?php endwhile; ?>
</tbody>

        </table>
    </div>
</div>

</body>
</html>